module namespace motor = 'http://creativosdigitales.co/paradigma';

declare function motor:ubl-ns(){  
  'declare namespace fe="http://www.dian.gov.co/contratos/facturaelectronica/v1";
declare namespace cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" ;
declare namespace cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
declare namespace cdt="urn:DocumentInformation:names:specification:ubl:colombia:schema:xsd:DocumentInformationAggregateComponents-1" ;
declare namespace clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001" ;
declare namespace clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001" ;
declare namespace clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003" ;
declare namespace cts="urn:carvajal:names:specification:ubl:colombia:schema:xsd:CarvajalAggregateComponents-1"; 
declare namespace ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" ;
declare namespace grl="urn:General:names:specification:ubl:colombia:schema:xsd:GeneralAggregateComponents-1"; 
declare namespace qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" ;
declare namespace sts="http://www.dian.gov.co/contratos/facturaelectronica/v1/Structures" ;
declare namespace udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" ;
declare namespace xsi="http://www.w3.org/2001/XMLSchema-instance" ;
declare namespace r="http://www.dian.gov.co/servicios/facturaelectronica/ReportarFactura";
'

};

(:
  
  Toma un documento en el fomarto intermedio de grupos
  y lo compilar como una consulta XQuery
  
:)
declare function motor:compilar($grupos){
 let $elements := for $a in $grupos/grupos/grupo
  return motor:procesar-grupo($a)  
 return (:"import module namespace excel  = 'http://creativosdigitales.co/excel' at 'excel.xqm'; 
" || :) 
 "import module namespace crd='urn:crd:util' at '..\xq\crd-util.xqm';" || 
 motor:ubl-ns() ||
 motor:declarar-variables($grupos) ||
  "&#13;&#10;(" ||
 string-join($elements,",&#13;&#10;") 
 || "&#10;&#13;)"
};

declare function motor:declarar-variables($grupos){
  (: Si el origen es una variable (comienza por $) agrega la declaracion de la variable externa :)
  
  for $var in $grupos/grupos/grupo/@origen
    return if( substring( $var,1,1 ) = "$" ) then  "&#13;&#10;declare variable " || $var || " external := ();" else ()
};

(:  Procesa una grupo individual :)
declare function motor:procesar-grupo($a){
  let $elementos := for $v in $a/variable return motor:procesar-variable($v)
  let $origen := $a/@origen
  let $indice := $a/@indice
  return
    if( empty( $a/@origen ) ) then
      (: Retornar solo un elemento :)
       "&#10;&#13;  element " || $a/@nombre || "{ " ||
        string-join( $elementos, "," ) ||
        " } "
    else        
      (: Crear un ciclo sobre una variable de entrada :)
      "&#10;&#13;  for " || $indice || " in " || $origen ||
      "&#10;&#13;    return element " || $a/@nombre || "{ attribute multi {true()}, " 
      ||
        string-join( $elementos, "," ) ||
        " } "
        
};

(: Ajusta el nombre de una variable para que sea un QName valido :)
declare function motor:ajustar-nombre($n){
  replace( $n, " ", "_" )
};

(: Genera el XQuery para una expresión individual, sea constante o formula :)
declare function motor:expresion( $var ){
  if($var/@formula = true() ) then 
    " (" || $var/text() || ")"
  else
    "'" || replace( $var/text(), '"', '&#34;') || "'"
  
};

(: Convierte un element <variable> en una expresión XQuery  :)
declare function motor:procesar-variable($var){
  "&#10;&#13;    element " || motor:ajustar-nombre($var/@nombre ) || "{" || motor:expresion($var) || " }"
};

(: 

  Ejecuta una acción compilada en XQuery, recibiendo los hechos como entrada

:)
declare function motor:ejecutar-grupo( $query, $bindings as map(*)? ){
    if( empty($query) or $query='') then
      ( trace($bindings),
        error(xs:QName('crd-error'), "XQuery vacío"))
    else
      xquery:eval( $query, $bindings)
    
};


  

 