module namespace dix="crd:dian:index";

import module namespace crd='urn:crd:util' at '..\xq\crd-util.xqm';declare namespace fe="http://www.dian.gov.co/contratos/facturaelectronica/v1";
declare namespace cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" ;
declare namespace cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
declare namespace cdt="urn:DocumentInformation:names:specification:ubl:colombia:schema:xsd:DocumentInformationAggregateComponents-1" ;
declare namespace clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001" ;
declare namespace clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001" ;
declare namespace clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003" ;
declare namespace cts="urn:carvajal:names:specification:ubl:colombia:schema:xsd:CarvajalAggregateComponents-1"; 
declare namespace ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" ;
declare namespace grl="urn:General:names:specification:ubl:colombia:schema:xsd:GeneralAggregateComponents-1"; 
declare namespace qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" ;
declare namespace sts="http://www.dian.gov.co/contratos/facturaelectronica/v1/Structures" ;
declare namespace udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" ;
declare namespace xsi="http://www.w3.org/2001/XMLSchema-instance" ;
declare namespace r="http://www.dian.gov.co/servicios/facturaelectronica/ReportarFactura";


(: Extrae el XML de un zip :)
declare function dix:desempacar-doc( $ruta ){
  
  let $archive := file:read-binary($ruta)
  let $xml := for $entry in archive:entries($archive)[not(ends-with(., '.pdf'))]
    return archive:extract-text($archive, $entry)  
  
  return parse-xml-fragment( $xml[1] )/*
};

(: Detecta el tipo de archivo y obtiene el documento que contiene :)
declare function dix:obtener-doc( $ruta ){
 let $_ := trace( $ruta, "importando" )
(: Si es ZIP, extraer el XML :)
let $doc := if( ends-with( lower-case( $ruta ), ".zip" ) ) then
              dix:desempacar-doc( $ruta)
            else
              doc($ruta)/*

(: Si es AttachedDocument, extraer el Invoice :)
let $fac := if( $doc/local-name() = "AttachedDocument" ) then
              parse-xml-fragment( $doc/*:Attachment[1]/*:ExternalReference/*:Description/string() )/*              
            else 
              $doc
return $fac

};

declare function dix:sentido( $doc, $nit-empresa ){
  if( $doc/cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID/string() = $nit-empresa ) then "enviados" else "recibidos"
};


declare function dix:nombre-doc( $doc ){
	switch ( $doc/local-name())
		case "Invoice" return "Factura"
		case "DebitNote" return "Nota Débito"
		case "CreditNote" return "Nota Crédito"
		case "ApplicationResponse" return "Evento"
		case "AttachedDocument" return "Adjunto"
		default return "Desconocido"
};



declare function dix:indice-doc( $doc, $nit-empresa ){

(
  element documento{ 
    element uuid { ($doc/cbc:UUID/string()) },
    element ruta { $doc/base-uri() },
    element tipo { dix:nombre-doc($doc) },
    element sentido { dix:sentido( $doc, $nit-empresa) },
    element uuid-ref { $doc/( cac:BillingReference/cac:InvoiceDocumentReference | cac:DocumentResponse[1]/cac:DocumentReference )/cbc:UUID/string() },
    element tipo-ref { "Factura"},
    element numero-ref { $doc/( cac:BillingReference/cac:InvoiceDocumentReference | cac:DocumentResponse[1]/cac:DocumentReference )/cbc:ID/string() },
    element fecha-ref {  $doc/cac:BillingReference/cac:InvoiceDocumentReference/cbc:IssueDate/string() },
    element orden_compra { $doc/cac:OrderReference/cbc:ID/string() },
    
    element prefijo{ (   $doc/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/*:DianExtensions/*:InvoiceControl/*:AuthorizedInvoices/*:Prefix/string()) },
    element numero{ ($doc/cbc:ID/string()) },
    element fecha{ ($doc/cbc:IssueDate/string()) },
    element año{ (substring( $doc/cbc:IssueDate, 1, 4)) },
    element mes{ (substring( $doc/cbc:IssueDate, 6, 2)) },
    element documento_emisor{ ($doc/(cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity | cac:DocumentResponse[1]/cac:IssuerParty/cac:PartyTaxScheme )/cbc:CompanyID/string()) },
    element nombre_emisor{ ($doc/(cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity | cac:DocumentResponse[1]/cac:IssuerParty/cac:PartyTaxScheme )/cbc:RegistrationName/string()) },
    element email_emisor{ ($doc/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:ElectronicMail/string()) },

    element documento_receptor{ ($doc/( cac:AccountingCustomerParty/cac:Party | cac:ReceiverParty )/cac:PartyTaxScheme/cbc:CompanyID/string()) },
    element nombre_receptor{ ($doc/( cac:AccountingCustomerParty/cac:Party | cac:ReceiverParty )/cac:PartyTaxScheme/cbc:RegistrationName/string()) },
    element email_receptor{ ($doc/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:ElectronicMail/string()) },

    element subtotal{ ($doc/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/string()) },
    element total_sin_impuestos{ ($doc/cac:LegalMonetaryTotal/cbc:TaxExclusiveAmount/string()) },
    (: element impuestos{ (sum($doc/cac:TaxTotal/cbc:TaxAmount/string())) }, :)
    (: element cargos_y_descuentos{ ($doc/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/string()) }, :)
    element gran_total{ ($doc/cac:LegalMonetaryTotal/cbc:PayableAmount/string()) },
    element eventos {}

     } 
)  
};

declare function dix:agregar-eventos( $doc, $eventos ){
    copy $new := $doc
  modify ( 
    replace node $new/eventos with element eventos { $eventos }
 	)
  return $new  
};

declare function dix:indice-evento( $doc, $uuid, $db ){
  let $eventos := 
  for $r in $doc//*:DocumentResponse/*:Response
  return 
  element evento{ 
    element uuid { ($doc/cbc:UUID/string()) },
    element ruta { $doc/base-uri() },
    element sentido { "evento" },
    element uuid-ref { string($uuid) },
    element tipo-ref { "Factura"},
    element numero-ref { $doc/( cac:DocumentResponse[1]/cac:DocumentReference )/cbc:ID/string() },
    element fecha-ref {  $doc/cac:BillingReference/cac:InvoiceDocumentReference/cbc:IssueDate/string() },
    
    (: element numero{ ($doc/cbc:ID/string()) },
    element fecha{ ($doc/cbc:IssueDate/string()) },
    element año{ (substring( $doc/cbc:IssueDate, 1, 4)) },
    element mes{ (substring( $doc/cbc:IssueDate, 6, 2)) }, :)
    
    element tipo { $r/cbc:ResponseCode/string() },
    element descripcion { $r/cbc:Description/string()  },
    element fecha { $r/cbc:EffectiveDate/string()  },
    element hora { $r/cbc:EffectiveTime/string() }
   } 
    
  let $factura := head($db/*[uuid = $uuid] )
  return if ( empty($factura)) then trace( (), "FACTURA NO ENCONTRADA " || $uuid ) else trace( dix:agregar-eventos( $factura, $eventos ) )
  (: return $eventos :)  
  
};


declare function dix:indice-evento-raiz( $doc, $uuid ){

(
  element documento{ 
    element uuid { ($doc/cbc:UUID/string()) },
    element ruta { $doc/base-uri() },
    element tipo { "Evento" },
    element sentido { "evento" },
    element uuid-ref { string($uuid) },
    element tipo-ref { "Factura"},
    element numero-ref { $doc/( cac:BillingReference/cac:InvoiceDocumentReference | cac:DocumentResponse[1]/cac:DocumentReference )/cbc:ID/string() },
    element fecha-ref {  $doc/cac:BillingReference/cac:InvoiceDocumentReference/cbc:IssueDate/string() },
    
    element prefijo{ (   $doc/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/*:DianExtensions/*:InvoiceControl/*:AuthorizedInvoices/*:Prefix/string()) },
    element numero{ ($doc/cbc:ID/string()) },
    element fecha{ ($doc/cbc:IssueDate/string()) },
    element año{ (substring( $doc/cbc:IssueDate, 1, 4)) },
    element mes{ (substring( $doc/cbc:IssueDate, 6, 2)) },
    element documento_emisor{ ($doc/(cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity | cac:DocumentResponse[1]/cac:IssuerParty/cac:PartyTaxScheme )/cbc:CompanyID/string()) },
    element nombre_emisor{ ($doc/(cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity | cac:DocumentResponse[1]/cac:IssuerParty/cac:PartyTaxScheme )/cbc:RegistrationName/string()) },
    element email_emisor{ ($doc/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:ElectronicMail/string()) },

    element documento_receptor{ ($doc/( cac:AccountingCustomerParty/cac:Party | cac:ReceiverParty )/cac:PartyTaxScheme/cbc:CompanyID/string()) },
    element nombre_receptor{ ($doc/( cac:AccountingCustomerParty/cac:Party | cac:ReceiverParty )/cac:PartyTaxScheme/cbc:RegistrationName/string()) },
    element email_receptor{ ($doc/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:ElectronicMail/string()) },

    element subtotal{ ($doc/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/string()) },
    element total_sin_impuestos{ ($doc/cac:LegalMonetaryTotal/cbc:TaxExclusiveAmount/string()) },
    (: element impuestos{ (sum($doc/cac:TaxTotal/cbc:TaxAmount/string())) }, :)
    (: element cargos_y_descuentos{ ($doc/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/string()) }, :)
    element gran_total{ ($doc/cac:LegalMonetaryTotal/cbc:PayableAmount/string()) } } 
)  
};


declare updating function dix:indexar-dir( $ruta, $dbname, $nit-empresa ){
(: try { :)
let $_ := trace( $ruta, "Indexando")
let $dir := $ruta

let $facturas := file:list( $dir, true(), "*.*" )
let $__ := trace($facturas)
  
  for $f in $facturas 
      let $_ := trace( $f, "idexando" )
      (: Determinar el tipo de archivo (XML o ZIP) :)
      let $dest := dix:obtener-doc( $dir || "\" || $f )
      let $url :=  $dest/cbc:UUID   (: dix:file-url( $dir, $f ) :)
      let $indice :=  if ( $dest/local-name() = 'ApplicationResponse' ) then
        dix:indice-evento( $dest, substring-before(file:name($f),'.'), collection($dbname) )  
      else
        dix:indice-doc( $dest, $nit-empresa )  
      return if(empty($indice) or $indice/uuid = "" ) then () else db:replace( $dbname, $indice/uuid, $indice ) 
(: } catch * {
  let $_e := trace( err:description )  
} :)

};

declare updating function dix:indexar-archivo( $ruta, $dbname, $nit-empresa ){
  let $f := $ruta  

  let $url := dix:file-url( $f )
  let $dest := dix:obtener-doc( $f )
  let $indice :=  dix:indice-doc( $dest, $nit-empresa ) 
  return db:replace( $dbname, $dest/cbc:UUID, $indice )
};



declare updating function dix:indexar-evento( $ruta, $dbname, $uuid ){
  let $f := $ruta  

  let $url := dix:file-url( $f )
  let $dest := dix:obtener-doc( $f )
  let $indice :=  dix:indice-evento( $dest, $uuid, collection($dbname) ) 
  return db:replace( $dbname, $indice/uuid, $indice )
};

declare function dix:file-url( $dir, $f ){
  replace( substring-after( $dir, ":") || "/" || $f, "\\", "/")
};

declare function dix:file-url( $f ){
  replace( substring-after( $f, ":"), "\\", "/")
};



declare function dix:lista-notas( $uuid, $db ){
  let $refs := $db/*[starts-with( uuid-ref, $uuid)]

  return $refs

};


declare function dix:numero-notas( $uuid, $db ){
  let $refs := dix:lista-notas( $uuid, $db )

  return $refs/numero

};


declare function dix:uuid-notas( $uuid, $db ){
  let $refs := dix:lista-notas( $uuid, $db )

  return $refs/uuid

};




