
import module namespace crd='urn:crd:util' at '..\xq\crd-util.xqm';declare namespace fe="http://www.dian.gov.co/contratos/facturaelectronica/v1";
declare namespace cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" ;
declare namespace cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
declare namespace cdt="urn:DocumentInformation:names:specification:ubl:colombia:schema:xsd:DocumentInformationAggregateComponents-1" ;
declare namespace clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001" ;
declare namespace clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001" ;
declare namespace clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003" ;
declare namespace cts="urn:carvajal:names:specification:ubl:colombia:schema:xsd:CarvajalAggregateComponents-1"; 
declare namespace ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" ;
declare namespace grl="urn:General:names:specification:ubl:colombia:schema:xsd:GeneralAggregateComponents-1"; 
declare namespace qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" ;
declare namespace sts="http://www.dian.gov.co/contratos/facturaelectronica/v1/Structures" ;
declare namespace udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" ;
declare namespace xsi="http://www.w3.org/2001/XMLSchema-instance" ;
declare namespace r="http://www.dian.gov.co/servicios/facturaelectronica/ReportarFactura";


(: Extrae el XML de un zip :)
declare function local:desempacar-doc( $ruta ){
  
  let $archive := file:read-binary($ruta)
  let $xml := for $entry in archive:entries($archive)[not(ends-with(., '.pdf'))]
    return archive:extract-text($archive, $entry)  
  
  return parse-xml-fragment( $xml[1] )/*
};

(: Detecta el tipo de archivo y obtiene el documento que contiene :)
declare function local:obtener-doc( $ruta ){
 
(: Si es ZIP, extraer el XML :)
let $doc := if( ends-with( lower-case( $ruta ), ".zip" ) ) then
              local:desempacar-doc( $ruta)
            else
              doc($ruta)/*

(: Si es AttachedDocument, extraer el Invoice :)
let $fac := if( $doc/local-name() = "AttachedDocument" ) then
              parse-xml-fragment( $doc/*:Attachment[1]/*:ExternalReference/*:Description/string() )/*              
            else 
              $doc
return $fac

};

declare function local:sentido( $doc, $nit-empresa ){
  if( $doc/cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID/string() = $nit-empresa ) then "enviados" else "recibidos"
};


declare function local:nombre-doc( $doc ){
	switch ( $doc/local-name())
		case "Invoice" return "Factura"
		case "DebitNote" return "Nota Débito"
		case "CreditNote" return "Nota Crédito"
		case "ApplicationResponse" return "Evento"
		case "AttachedDocument" return "Adjunto"
		default return "Desconocido"
};



declare function local:indice-doc( $doc, $nit-empresa ){

(
  element documento{ 
    element uuid { ($doc/cbc:UUID/string()) },
    element ruta { $doc/base-uri() },
    element tipo { local:nombre-doc($doc) },
    element sentido { local:sentido( $doc, $nit-empresa) },
    element uuid-ref { $doc/cac:BillingReference/cac:InvoiceDocumentReference/cbc:UUID/string() },
    element tipo-ref { "Factura"},
    element numero-ref { $doc/cac:BillingReference/cac:InvoiceDocumentReference/cbc:ID/string() },
    element fecha-ref { $doc/cac:BillingReference/cac:InvoiceDocumentReference/cbc:IssueDate/string() },
    element orden_compra { $doc/cac:OrderReference/cbc:ID/string() },
    
    
    element prefijo{ ($doc/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/*:DianExtensions/*:InvoiceControl/*:AuthorizedInvoices/*:Prefix/string()) },
    element numero{ ($doc/cbc:ID/string()) },
    element fecha{ ($doc/cbc:IssueDate/string()) },
    element año{ (substring( $doc/cbc:IssueDate, 1, 4)) },
    element mes{ (substring( $doc/cbc:IssueDate, 6, 2)) },
    element documento_emisor{ ($doc/cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID/string()) },
    element nombre_emisor{ ($doc/cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:RegistrationName/string()) },
    element email_emisor{ ($doc/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:ElectronicMail/string()) },

    element documento_receptor{ ($doc/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cbc:CompanyID/string()) },
    element nombre_receptor{ ($doc/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cbc:RegistrationName/string()) },
    element email_receptor{ ($doc/cac:AccountingCustomerParty/cac:Party/cac:Contact/cbc:ElectronicMail/string()) },

    element subtotal{ ($doc/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/string()) },
    element total_sin_impuestos{ ($doc/cac:LegalMonetaryTotal/cbc:TaxExclusiveAmount/string()) },
    (: element impuestos{ (sum($doc/cac:TaxTotal/cbc:TaxAmount/string())) }, :)
    (: element cargos_y_descuentos{ ($doc/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/string()) }, :)
    element gran_total{ ($doc/cac:LegalMonetaryTotal/cbc:PayableAmount/string()) } } 
)  
};

declare updating function local:indexar-dir( $ruta, $dbname, $nit-empresa ){
let $dir := $ruta

let $facturas := file:list( $dir, true(), "*.*" )
  
  (: let $mapa := doc( $mapa ) :)
  
  (: let $q := motor:compilar( $mapa ) :)
  
  for $f in $facturas 
      (: Determinar el tipo de archivo (XML o ZIP) :)
      let $url := local:file-url( $dir, $f )
      let $dest := local:obtener-doc( $url )
      let $indice :=  local:indice-doc( $dest, $nit-empresa )  (: local:extraer-datos( $q, doc( $dest ) ) :)   
      return db:replace( $dbname, $url, $indice )
};

declare function local:file-url( $dir, $f ){
  replace( substring-after( $dir, ":") || "/" || $f, "\\", "/")
};


(: local:indice-doc( doc( "C:\repos\fe\archivos\recibidos\2025\02\CreditNote--NCPR33.xml" )/*, "9999999" ) :)
(: local:indice-doc( doc( "C:\repos\fe\archivos\recibidos\2025\02\Invoice--DS923.xml" )/*, "9999999" ) :)

(: db:create('merkfrutos') :)

local:indexar-dir( "C:\repos\fe\archivos", "merkfrutos", "901076182" )