module namespace html="crd:fe:html";

import module namespace ev="crd:dian:eventos" at '..\xq\eventos.xqm';
import module namespace dix="crd:dian:index" at '..\xq\indice-dian.xqm';

declare function html:headers(){
    <thead>
    <tr>
      <th>tipo</th>
      <th>sentido</th>

      <th>numero</th>
      <th>fecha</th>
      <th>año</th>
      <th>mes</th>

      <th>tipo-ref</th>
      <th>numero-ref</th>
      <th>fecha-ref</th>

      <th>documento_emisor</th>
      <th>nombre_emisor</th>
      <th>email_emisor</th>
      <th>documento_receptor</th>
      <th>nombre_receptor</th>
      <th>email_receptor</th>
      <th>subtotal</th>
      <th>total_sin_impuestos</th>
      <th>gran_total</th>
      <th>Referencias</th>
      <th>Eventos</th>
      <th>CUFE/CUDE</th>
      <th>ruta</th>
    </tr>
  </thead>
};

declare function html:mini-headers(){
    <thead>
    <tr>
      <th>numero</th>
      <th>fecha</th>

      <th>documento_receptor</th>
      <th>nombre_receptor</th>
      <th>documento_emisor</th>
      <th>nombre_emisor</th>
      <th>orden_compra</th>
      
      <th>acuse</th>
      <th>recibo</th>
      <th>expresa</th>
      <th>tacita</th>
      <th>rechazo</th>
      <th>uuid</th>
      
    </tr>
  </thead>
};


declare function html:mini-row( $d, $db ){
  <tr>
      
     { (: <td><a href="https://catalogo-vpfe.dian.gov.co/document/searchqr?documentkey={$d/uuid/string()}" target="_blank">{$d/numero/string()}</a></td> :) }
      <td>{$d/numero/string()}</td>
      <td>{$d/fecha/string()}</td>

      <td>{$d/documento_receptor/string()}</td>
      <td>{$d/nombre_receptor/string()}</td>

      <td>{$d/documento_emisor/string()}</td>
      <td>{$d/nombre_emisor/string()}</td>

      <td>{$d/orden_compra/string()}</td>

      <td>{ ev:fecha-evento( $d, '030' ) }</td>
      <td>{ ev:fecha-evento( $d, '032' ) }</td>
      <td>{ ev:fecha-evento( $d, '033' ) }</td>
      <td>{ ev:fecha-evento( $d, '034' ) }</td>
      <td>{ ev:fecha-evento( $d, '031' ) }</td>
      <td>{$d/uuid/string()}</td>
    </tr>      
};

declare function html:row( $d, $db ){
  <tr>
      <td>{$d/tipo/string()}</td>
      <td>{$d/sentido/string()}</td>

      <td>{$d/numero/string()}</td>
      <td>{$d/fecha/string()}</td>
      <td>{$d/año/string()}</td>
      <td>{$d/mes/string()}</td>

      <td>{$d/tipo-ref/string()}</td>
      <td>{$d/numero-ref/string()}</td>
      <td>{$d/fecha-ref/string()}</td>
      <td>{$d/documento_emisor/string()}</td>
      <td>{$d/nombre_emisor/string()}</td>
      <td>{$d/email_emisor/string()}</td>
      <td>{$d/documento_receptor/string()}</td>
      <td>{$d/nombre_receptor/string()}</td>
      <td>{$d/email_receptor/string()}</td>
      <td>{$d/subtotal/string()}</td>
      <td>{$d/total_sin_impuestos/string()}</td>
      <td>{$d/gran_total/string()}</td>
      <td>{ (: dix:numero-notas( $d ) :) }</td>
      <td>{ ev:lista-eventos( $d ) }</td>
      <td>{$d/uuid/string()}</td>
      <td>{$d/ruta/string()}</td>
    </tr>      
};


declare function html:detail-table( $d, $db ){
  element table {
    attribute id {"listado"},
    html:mini-headers()
    (: element thead {
      element tr {
        for $h in head($d)/*/* 
          return element td { $h/name() }
      }
    } :),
    element tbody {
    for $row in $d
      return html:mini-row($row,$db)
      (: element tr {
            for $c in $row/* 
              return element td { $c/string() }
      } :)
    }
  }
};

declare function html:html( $doc, $db ){
    let $names := distinct-values( $doc/name() )
    let $result :=
    for $n in $names
      let $g := $doc[ name() = $n ]
      return element div {
        (: element h2 {  head($g)/name() }, :)
        (: Determinar si es un elemento multiple de detalle o unico :)
        if ( count($g) > 1 ) then
          html:detail-table( $g, $db )
        else
          element table {
            for $r in $g/*
              return element tr {
                element td { $r/name() },
                element td { $r/string() }
              }
          }
      }
    return $result
};