import module namespace motor = 'http://creativosdigitales.co/paradigma' at '..\xq\paradigma.xqm';

declare namespace cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" ;
declare namespace cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";

declare variable $ruta-archivos external := "C:\CORREOS\entrada";
declare variable $mapa external := "..\xq\mapas\encabezado.xml";
declare variable $ruta-destino external := "C:\CORREOS\salida";

declare function local:extraer-zip( $ruta, $dest ){
  
};

declare function local:obtener-ruta( $xml, $base  ){
  let $nro := $xml/cbc:ID
  let $a := substring( $xml/cbc:IssueDate, 1, 4)
  let $mes := substring( $xml/cbc:IssueDate, 6, 2)
  let $nit := $xml/cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID
  let $nombre := $xml/cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:RegistrationName
  let $dir := $base || "\" || $a || "\" ||  $mes  let $_ := file:create-dir ($dir)
  return $dir || "\" || $nit || " - " || $nro || ".xml"
};

declare function local:extraer-xml( $ruta, $ruta-dest ){
  try { 
     let $doc := local:obtener-doc( $ruta ) 

     let $dest := local:obtener-ruta( $doc, $ruta-dest )

     let $_ := file:write-text( $dest, serialize($doc) )

      return $dest
  } 
  catch * 
    { let $_ := trace( "error: " || $err:description ) (: No es un XML :) return $_  }
};

declare function local:extraer-datos( $q, $body ){
 let $doc :=   $body 
 return xquery:eval( $q, map { "": $doc} )

};

(: Extrae el XML de un zip :)
declare function local:desempacar-doc( $ruta ){
  
  let $archive := file:read-binary($ruta)
  let $xml := for $entry in archive:entries($archive)[not(ends-with(., '.pdf'))]
    return archive:extract-text($archive, $entry)  
  
  return parse-xml-fragment( $xml[1] )/*
};

(: Detecta el tipo de archivo y obtiene el documento que contiene :)
declare function local:obtener-doc( $ruta ){
 
(: Si es ZIP, extraer el XML :)
let $doc := if( ends-with( lower-case( $ruta ), ".zip" ) ) then
              local:desempacar-doc( $ruta)
            else
              doc($ruta)/*

(: Si es AttachedDocument, extraer el Invoice :)
let $fac := if( $doc/local-name() = "AttachedDocument" ) then
              parse-xml-fragment( $doc/*:Attachment[1]/*:ExternalReference/*:Description/string() )/*              
            else 
              $doc
return $fac

};


let $dir := $ruta-archivos 

let $facturas := file:list( $dir, true(), "*.*" )

(: let $mapa := doc( $mapa ) :)

(: let $q := motor:compilar( $mapa ) :)

let $r := 
for $f in $facturas 
    (: Determinar el tipo de archivo (XML o ZIP) :)
    let $dest := local:extraer-xml( $dir || "\" || $f, $ruta-destino )
    return $dest   (: local:extraer-datos( $q, doc( $dest ) ) :)
 
return ()
 