import module namespace motor = 'http://creativosdigitales.co/paradigma' at '..\xq\paradigma.xqm';

declare variable $ruta-xml external := "C:\einvoice\files\demo\SETP990000009.fe";
declare variable $mapa external := "..\xq\mapas\campos-factura-det.xml";

declare function local:detail-table( $d ){
  element table {
    element thead {
      element tr {
        for $h in head($d)/* 
          return element td { $h/name() }
      }
    },
    element tbody {
    for $row in $d
      return element tr {
            for $c in $d/* 
              return element td { $c/string() }
      }
    }
  }
};

declare function local:html( $doc ){
    let $names := distinct-values( $doc/name() )
    let $result :=
    for $n in $names
      let $g := $doc[ name() = $n ]
      return element div {
        element h2 {  head($g)/name() },
        (: Determinar si es un elemento multiple de detalle o unico :)
        if ( count($g) > 1 ) then
          local:detail-table( $g )
        else
          element table {
            for $r in $g/*
              return element tr {
                element td { $r/name() },
                element td { $r/string() }
              }
          }
      }
    return element html { element body {$result}}
};

let $mapa := doc( $mapa )

let $q := motor:compilar( $mapa )

 let $body := doc( $ruta-xml )

 let $doc := if( $body/*/name() = "AttachedDocument" ) then
     parse-xml-fragment( $body/*/*:Attachment[1]/*:ExternalReference/*:Description/string() )
 else
    $body 

 let $r := xquery:eval( $q, map { "": $doc} )

 return ( local:html( $r ) )
 
  (: return $r :)