(: Utilidades para generacion de facturas electrónicas :)

module namespace crd="urn:crd:fe-util"; 

declare namespace fe="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2";
declare namespace cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" ;
declare namespace cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
declare namespace cdt="urn:DocumentInformation:names:specification:ubl:colombia:schema:xsd:DocumentInformationAggregateComponents-1" ;
declare namespace clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001" ;
declare namespace clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001" ;
declare namespace clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003" ;
declare namespace cts="urn:carvajal:names:specification:ubl:colombia:schema:xsd:CarvajalAggregateComponents-1"; 
declare namespace ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" ;
declare namespace grl="urn:General:names:specification:ubl:colombia:schema:xsd:GeneralAggregateComponents-1"; 
declare namespace qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" ;
declare namespace sts="http://www.dian.gov.co/contratos/facturaelectronica/v1/Structures" ;
declare namespace udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" ;
declare namespace xsi="http://www.w3.org/2001/XMLSchema-instance" ;
declare namespace r="http://www.dian.gov.co/servicios/facturaelectronica/ReportarFactura";

(: Calcula el digito de verificacion de un NIT o Cedula :)
declare function crd:dv( $nit ){
  (: Vector de primos suminsitrdo por la DIAN :)
  let $vector := array { 3, 7, 13, 17, 19, 23, 29, 37, 41, 43, 47, 53, 59, 67, 71 }
  
  let $base := string-to-codepoints('0')
  
  let $digitos := string-to-codepoints( normalize-space($nit) )
  
  (: Suma los productos de cada digito por la posicion correcpondiente en el vetor de primos :)
  let $acumulador := sum( 
    for $d at $contador in $digitos  
      let $temp := $d - $base
      return $temp * $vector( count($digitos)-$contador+1 )
  )
  
  (: El DV es el reduo de dividir por 11 :)
  let $residuo := $acumulador mod 11
  
  return if($residuo > 1 ) then 11 - $residuo else $residuo 
};

(: Retorna la fecha en el formato sin separadores usado para el QR:)
declare function crd:shortdate($d){
  substring( $d,1,4) || substring( $d,6,2) || substring( $d,9,2) 
};

(: Retorna la parte fecha de una cadena de fecha complete :)
declare function crd:date($d){
  substring( $d,1,10)
};

(: Retorna solo la hora de una cadena de fecha completa :)
declare function crd:time($d){
  substring( $d,12,20)
};

(: Representa un numero grande en formato admisible por la DIAN :)
declare function crd:formato-numero($n){
  
   format-number(xs:decimal($n),'0.00') 
};
declare function crd:numero($n){
   xs:decimal(replace($n,',',''))
};


(: Extrae los datos que confirman el CUFE de una factura :)
declare function crd:semilla-cufe( $fe ){

let $semilla :=
map{  'NumFac' : $fe/fe:Invoice/cbc:ID/string() ,
  'FecFac' : $fe/fe:Invoice/cbc:IssueDate/string() ,
  'HoraFactura' : $fe/fe:Invoice/cbc:IssueTime/string() ,
  'ValorBruto' : $fe/fe:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/number() ,
  'CodImp1' : '01'  ,
  'ValorImpuesto1' : sum( $fe/fe:Invoice/cac:TaxTotal[cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '01']/cbc:TaxAmount )  ,
  'CodImp2' : '04'  , 
  'ValorImpuesto2' : sum($fe/fe:Invoice/cac:TaxTotal[cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '04' ]/cbc:TaxAmount)  ,
  'CodImp3' : '03' , 
  'ValorImpuesto3' : sum($fe/fe:Invoice/cac:TaxTotal[cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '03']/cbc:TaxAmount)  ,
  'ValorTotalaPagar' : $fe/fe:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/number() ,
  'NitOFE' : $fe/fe:Invoice/ cac:AccountingSupplierParty/cac:Party/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  'NumAdq' : $fe/fe:Invoice/ cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  'Ambiente' : $fe/fe:Invoice/cbc:ProfileExecutionID/string()  
}

return $semilla   
  
};


(: Representa un numero grande en formato admisible por la DIAN para los porcentjes de impuestos :)
declare function crd:formato-impuestos($n){
   format-number(xs:decimal($n),'0.00')
};

declare function crd:taxtotal-nominal($schemeid, $lines ){
  let $currency := "COP"
  let $selected := $lines/cac:TaxTotal/cac:TaxSubtotal[  cac:TaxCategory/cac:TaxScheme/cbc:ID/text() = $schemeid ] 
  
  let $schemename := $selected[1]/cac:TaxCategory/cac:TaxScheme/cbc:Name/string()
  (: let $percent := $selected[1]/cac:TaxCategory/cbc:Percent/string() :)
  
  let $r := if ( empty($selected) ) then () else
			<cac:TaxTotal>
			<cbc:TaxAmount currencyID="{ $currency }">{ crd:formato-numero(sum($selected/cbc:TaxAmount ) ) }</cbc:TaxAmount>
			<cac:TaxSubtotal>
        <cbc:TaxableAmount currencyID="{ $currency }">{ crd:formato-numero( sum($selected/cbc:TaxableAmount ) ) }</cbc:TaxableAmount>
        <cbc:TaxAmount currencyID="{ $currency }">{ crd:formato-numero( sum($selected/cbc:TaxAmount ) )}</cbc:TaxAmount>
        <cac:TaxCategory>
        
          <cbc:BaseUnitMeasure unitCode="94">{  crd:formato-numero( sum($selected/cac:TaxCategory/cbc:BaseUnitMeasure ) ) }</cbc:BaseUnitMeasure>
          <cbc:PerUnitAmount currencyID="{ $currency }">{  crd:formato-numero( sum($selected/cac:TaxCategory/cbc:PerUnitAmount ) )  }</cbc:PerUnitAmount>
          
          <cac:TaxScheme>
            <cbc:ID>{$schemeid}</cbc:ID>
            <cbc:Name>{$schemename}</cbc:Name>
          </cac:TaxScheme>
        </cac:TaxCategory>
		  </cac:TaxSubtotal>
		</cac:TaxTotal>  
    return $r
};

declare function crd:taxtotal-nopercent($schemeid, $lines ){
  let $currency := "COP"
  let $selected := $lines/cac:TaxTotal/cac:TaxSubtotal[  cac:TaxCategory/cac:TaxScheme/cbc:ID/text() = $schemeid ] 
  
  let $schemename := $selected[1]/cac:TaxCategory/cac:TaxScheme/cbc:Name/string()
  let $percent := $selected[1]/cac:TaxCategory/cbc:Percent/string()
  
  let $r := if ( empty($selected) ) then () else
			<cac:TaxTotal>
			<cbc:TaxAmount currencyID="{ $currency }">{ crd:formato-numero(sum($selected/cbc:TaxAmount ) ) }</cbc:TaxAmount>
			<cac:TaxSubtotal>
        <cbc:TaxableAmount currencyID="{ $currency }">{ crd:formato-numero( sum($selected/cbc:TaxableAmount ) ) }</cbc:TaxableAmount>
        <cbc:TaxAmount currencyID="{ $currency }">{ crd:formato-numero( sum($selected/cbc:TaxAmount ) )}</cbc:TaxAmount>
        <cac:TaxCategory>
          <cbc:Percent>{$percent}</cbc:Percent>
          <cac:TaxScheme>
            <cbc:ID>{$schemeid}</cbc:ID>
            <cbc:Name>{$schemename}</cbc:Name>
          </cac:TaxScheme>
        </cac:TaxCategory>
		  </cac:TaxSubtotal>
		</cac:TaxTotal>  
    return $r
};

declare function crd:taxtotal-for($schemeid, $percent,$lines ){
  let $currency := "COP"
  let $selected := $lines/cac:TaxTotal/cac:TaxSubtotal[ cac:TaxCategory/cbc:Percent = $percent  and  cac:TaxCategory/cac:TaxScheme/cbc:ID/text() = $schemeid ] 
  
  let $schemename := $selected[1]/cac:TaxCategory/cac:TaxScheme/cbc:Name/string()
  let $r :=
			<cac:TaxSubtotal>
        <cbc:TaxableAmount currencyID="{ $currency }">{ crd:formato-numero( sum($selected/cbc:TaxableAmount ) ) }</cbc:TaxableAmount>
        <cbc:TaxAmount currencyID="{ $currency }">{ crd:formato-numero( sum($selected/cbc:TaxAmount ) )}</cbc:TaxAmount>
        <cac:TaxCategory>
          <cbc:Percent>{crd:formato-impuestos($percent)}</cbc:Percent>
          <cac:TaxScheme>
            <cbc:ID>{$schemeid}</cbc:ID>
            <cbc:Name>{$schemename}</cbc:Name>
          </cac:TaxScheme>
        </cac:TaxCategory>
		  </cac:TaxSubtotal>
    return $r
};


declare function crd:taxtotals(  $lines ){
   let $currency := "COP"
   let $taxids := distinct-values( $lines/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID )   
   for $i in $taxids 
     let $subTotal := sum($lines/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:ID/text() = $i ]/cbc:TaxAmount)
     let $percents := distinct-values( $lines/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[cac:TaxScheme/cbc:ID = $i]/cbc:Percent )
     return 
       (: Evitar los impuestos nominales :)
       if( not( empty( $percents ))) then
      <cac:TaxTotal>
			<cbc:TaxAmount currencyID="{ $currency }">{ crd:formato-numero($subTotal) }</cbc:TaxAmount>
      {( for $p in $percents order by number($p) descending return crd:taxtotal-for( $i, $p, $lines ))}
		  </cac:TaxTotal> else (),
			crd:taxtotal-nopercent( '02', $lines ),
      crd:taxtotal-nominal( 'ZZ', $lines )
};

declare function crd:read-ini( $path ){
   let $txt := file:read-text-lines($path)
   let $m := for $line in $txt 
   return map:entry( substring-before($line,"="), substring-after($line,"=")  )
   return map:merge($m)
};