module namespace ev="crd:dian:eventos";

(: Determina si una factura esta´pendiente por recibir evento de aceptación tácita o expresa :)
declare function ev:esta-pendiente( $factura ){
    empty( $factura/eventos/evento[ tipo = ("031","033","034")] )
};

(: Obtener la lista de facturas que aun no tienen aceptacion tácita o expresa :)
declare function ev:lista-pendientes( $db, $fecha-minima ){
  (: Obtener documentos desde la fecha de corte :)
  let $refs := $db/*[ tipo = "Factura" and fecha >= $fecha-minima and (ev:esta-pendiente(.) ) ]
  return $refs
};


declare function ev:tiene-reclamo( $factura ){
    exists( $factura/eventos/evento[ tipo = ("031")] )
};

declare function ev:lista-reclamos( $db, $fecha-minima ){
  (: Obtener documentos desde la fecha de corte :)
  let $refs := $db/*[ tipo = "Factura" and fecha >= $fecha-minima and (ev:tiene-reclamo(.) ) ]
  return $refs
};

declare function ev:fecha-evento( $factura, $codigo ){
  
  let $evs := for $r in $factura/eventos/evento[tipo = $codigo]
    return $r/fecha || ":" || $r/hora
    
  return if(empty($evs)) then "-" else $evs
};

declare function ev:lista-eventos( $factura ){

  let $evs := for $r in $factura/eventos/evento
    return map:entry( $r/tipo/string(), $r/fecha || ":" || $r/hora )
    
  return map:merge( $evs )
};