module namespace dian="crd:dian:uuids";

declare namespace fe="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2";
declare namespace cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" ;
declare namespace cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";declare namespace cdt="urn:DocumentInformation:names:specification:ubl:colombia:schema:xsd:DocumentInformationAggregateComponents-1" ;
declare namespace clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001" ;
declare namespace clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001" ;
declare namespace clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003" ;
declare namespace cts="urn:carvajal:names:specification:ubl:colombia:schema:xsd:CarvajalAggregateComponents-1"; 
declare namespace ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" ;
declare namespace grl="urn:General:names:specification:ubl:colombia:schema:xsd:GeneralAggregateComponents-1"; 
declare namespace qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" ;
declare namespace sts="http://www.dian.gov.co/contratos/facturaelectronica/v1/Structures" ;
declare namespace udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" ;
declare namespace xsi="http://www.w3.org/2001/XMLSchema-instance" ;
declare namespace r="http://www.dian.gov.co/servicios/facturaelectronica/ReportarFactura";

(: Semilla para el CUDS a partir de un documento y el PIN del software :)
declare function dian:semilla-cuds( $fe, $pin ){

let $semilla := ( 
  (: "NumDS": :) $fe/cbc:ID/string() ,
  (: "FecDS": :) $fe/cbc:IssueDate/string() ,
  (: "HordS": :) $fe/cbc:IssueTime/string() ,
  (: "Valds": :) $fe/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/string() ,
  (: "CodImp1": :) '01' ,
  (: "ValImp": :) format-number( sum($fe/*/cac:TaxTotal[ cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '01' ]/cbc:TaxAmount), "0.00" ),

  (: "ValTot": :) $fe/cac:LegalMonetaryTotal/cbc:PayableAmount/string() ,
  (: "NumSNO": :) $fe/cac:AccountingSupplierParty/cac:Party/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  (: "NumABS": :) $fe/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  (: SW PIN :) $pin,
  (: "Ambiente": :) $fe/cbc:ProfileExecutionID/string()  
)

return $semilla
};


(: Calcula el CUDS de un Documento XML :)
declare function dian:cuds-doc( $doc, $pin ){
  let $s := dian:semilla-cuds( $doc, $pin )
  let $str := string-join($s)
  let $uuid := lower-case( string(xs:hexBinary(hash:hash($str, "SHA-384"))) )

  return $uuid
};

declare function dian:semilla-cufe( $fe, $technical-key ){

let $_ := if( empty($technical-key) or $technical-key = '') then
  error( QName("crd:error","no-key"), "No se encontró la clave técnica para la numeración de la factura"  )
  else ()

let $semilla := ( 
  (: "NumFac": :) $fe/fe:Invoice/cbc:ID/string() ,
  (: "FecFac": :) $fe/fe:Invoice/cbc:IssueDate/string() ,
  (: "HorFac": :) $fe/fe:Invoice/cbc:IssueTime/string() ,
  (: "ValFac": :) $fe/fe:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/string() ,
  (: "CodImp1": :) '01' ,
  (: "ValImp1": :) format-number( sum($fe/fe:Invoice/cac:TaxTotal[ cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '01' ]/cbc:TaxAmount), "0.00" ),
  (: "CodImp2": :) '04', 
  (: "ValImp2": :)  format-number( sum( $fe/fe:Invoice/cac:TaxTotal[ cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '04' ]/cbc:TaxAmount ), "0.00") ,
  (: "CodImp3" :) '03', 
  (: "ValImp3": :) format-number( sum($fe/fe:Invoice/cac:TaxTotal[cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '03']/cbc:TaxAmount ), "0.00" ) ,
  (: "ValTot": :) $fe/fe:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/string() ,
  (: "NitOfe": :) $fe/fe:Invoice/ cac:AccountingSupplierParty/cac:Party/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  (: "NumAdq": :) $fe/fe:Invoice/ cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  $technical-key,
  (: "Ambiente": :) $fe/fe:Invoice/cbc:ProfileExecutionID/string()  
)
let $__ := trace(string-join($semilla,"|"))
return string-join($semilla,"")  
};

(: Se conserva para compatibilidad con la generacion del CUDE de notas credito anterior :)
declare function dian:semilla-cude( $fe, $pin ){
   dian:semilla-cude-nc( $fe, $pin )
};

(: Cadena semilla para el CUDE de las notas credito :)
declare function dian:semilla-cude-nc( $fe, $pin ){
  
let $semilla := ( 
  (: "NumDE": :) $fe/*/cbc:ID/string() ,
  (: "FecDE": :) $fe/*/cbc:IssueDate/string() ,
  (: "HorDE": :) $fe/*/cbc:IssueTime/string() ,
  (: "ValDE": :) $fe/*/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/string() ,
  (: "CodImp1": :) '01' ,
  (: "ValImp": :) format-number( sum($fe/*/cac:TaxTotal[ cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '01' ]/cbc:TaxAmount), "0.00" ),
  (: "CodImp1": :) '04' ,
  (: "ValImp": :) format-number( sum($fe/*/cac:TaxTotal[ cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '04' ]/cbc:TaxAmount), "0.00" ),
  (: "CodImp1": :) '03' ,
  (: "ValImp": :) format-number( sum($fe/*/cac:TaxTotal[ cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '03' ]/cbc:TaxAmount), "0.00" ),

  (: "ValTot": :) $fe/*/cac:LegalMonetaryTotal/cbc:PayableAmount/string() ,
  (: "NumETA": :) $fe/*/cac:AccountingSupplierParty/cac:Party/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  (: "NumADQ": :) $fe/*/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  (: SW PIN :) $pin,
  (: "Ambiente": :) $fe/*/cbc:ProfileExecutionID/string()  
)
(: return string-join($semilla,"") :)  
return $semilla
};

(: CUDE para Documentos Electrónicos de Transmisión (POS, extracto, tiquetes, espectaculos, etc) :) 
declare function dian:semilla-cude-det( $fe, $pin ){
  
let $semilla := ( 
  (: "NumDE": :) $fe/*/cbc:ID/string() ,
  (: "FecDE": :) $fe/*/cbc:IssueDate/string() ,
  (: "HorDE": :) $fe/*/cbc:IssueTime/string() ,
  (: "ValDE": :) $fe/*/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/string() ,
  (: "CodImp1": :) '01' ,
  (: "ValImp": :) format-number( sum($fe/*/cac:TaxTotal[ cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '01' ]/cbc:TaxAmount), "0.00" ),
  (: "CodImp1": :) '04' ,
  (: "ValImp": :) format-number( sum($fe/*/cac:TaxTotal[ cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '04' ]/cbc:TaxAmount), "0.00" ),
  (: "CodImp1": :) '03' ,
  (: "ValImp": :) format-number( sum($fe/*/cac:TaxTotal[ cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID = '03' ]/cbc:TaxAmount), "0.00" ),

  (: "ValTot": :) $fe/*/cac:LegalMonetaryTotal/cbc:PayableAmount/string() ,
  (: "NumETA": :) $fe/*/cac:AccountingSupplierParty/cac:Party/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  (: "NumADQ": :) $fe/*/cac:AccountingCustomerParty/cac:Party/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  (: SW PIN :) $pin,
  (: "Ambiente": :) $fe/*/cbc:ProfileExecutionID/string()  
)
(: return string-join($semilla,"") :)  
return $semilla
};


(: SoftwareSecurityCode a partir d elos datos qu elo componen :)
declare function dian:securitycode( $idsw, $pin, $nr ){
  let $semilla := $idsw || $pin || $nr
  let $_ := trace($idsw || $pin || $nr)
  return lower-case( string(xs:hexBinary(hash:hash($semilla, "SHA-384"))) )
};

(: ID del Software a partir de un Documento existente :)
declare function dian:swid-doc( $doc, $pin ){
  dian:securitycode( $doc//*:SoftwareID, $pin, $doc/*/cbc:ID )
};

declare function dian:semilla-swid-doc( $doc, $pin ){
  ( $doc//*:SoftwareID, $pin, $doc/*/cbc:ID )
};


declare function dian:semilla-radian-cude( $fe, $pin ){
  
let $semilla := ( 
  (: "NumDE": :) $fe/*/cbc:ID/string() ,
  (: "FecDE": :) $fe/*/cbc:IssueDate/string() ,
  (: "HorDE": :) $fe/*/cbc:IssueTime/string() ,
  (: "CompanyID": :) $fe/*/cac:SenderParty/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  (: "CompanyID": :) $fe/*/cac:ReceiverParty/cac:PartyTaxScheme/cbc:CompanyID/string() ,
  (: "ResponseCode": :) $fe/*/cac:DocumentResponse/cac:Response/cbc:ResponseCode/string() ,
  (: "ID": :) $fe/*/cac:DocumentResponse/cac:DocumentReference/cbc:ID/string() ,
  (: "ID": :) $fe/*/cac:DocumentResponse/cac:DocumentReference/cbc:DocumentTypeCode/cbc:ID/string() ,
  "01",
  (: SW PIN :) $pin
)
(: return string-join($semilla,"") :)  
return $semilla
};
