declare namespace cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2";
declare namespace cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" ;
declare namespace ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" ;
			
declare variable $nit-empresa external := "";

let $sentido := if( /*/cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID/string() = $nit-empresa ) then "enviados" else "recibidos"
let $m := map {
	"sentido" : $sentido,
    "cufe"  : /*/cbc:UUID/string(),
    "prefijo"  : /*/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/*:DianExtensions/*:InvoiceControl/*:AuthorizedInvoices/*:Prefix/string(),
    "numero"  : /*/cbc:ID/string(),
    "fecha"  : /*/cbc:IssueDate/string(),
    "año"  : substring( /*/cbc:IssueDate, 1, 4),
    "mes"  : substring( /*/cbc:IssueDate, 6, 2),
    "nombre_ubl"  : /*/local-name(),
    "nombre_documento"  : 
	switch (/*/local-name())
		case "Invoice" return "Factura"
		case "DebitNote" return "Nota Débito"
		case "CreditNote" return "Nota Crédito"
		case "ApplicationResponse" return "Evento"
		case "AttachedDocument" return "Adjunto"
		default return "Desconocido"	,
    "documento_identificacion"  : if($sentido = "enviados") then
		 /*/cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID/string()
		else
		 /*/cac:AccountingCustomerParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID/string(),
    "documento_facturador"  : /*/cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID/string(),
    "nombre_facturador"  : /*/cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:RegistrationName/string(),
    "documento_adquiriente"  : /*/cac:AccountingCustomerParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID/string(),
    "nombre_adquiriente"  : /*/cac:AccountingCustomerParty/cac:Party/cac:PartyLegalEntity/cbc:RegistrationName/string(),
    "subtotal"  : /*/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/string(),
    "total_sin_impuestos"  : /*/cac:LegalMonetaryTotal/cbc:TaxExclusiveAmount/string(),
    "gran_total"  : /*/cac:LegalMonetaryTotal/cbc:PayableAmount/string()
}	
return json:serialize($m)