module namespace crd="urn:crd:util"; 
declare namespace gc="http://docs.oasis-open.org/codelist/ns/genericode/1.0/";

declare function crd:gc-lookup( $genericode-file, $codigo ) {
  let $gc :=  db:open( "dian", $genericode-file || "-2.1.gc"  )
  
  let $human := for $v in $gc/gc:CodeList/SimpleCodeList/Row[ Value/@ColumnRef="code" and Value/SimpleValue = $codigo  ]/Value
    return element { if( $v/@ColumnRef/string() = "code") then "codigo" else "nombre" } { $v/SimpleValue/string() }

  let $factory := for $v in $gc/gc:CodeList/SimpleCodeList/Row[ Value/@ColumnRef="code" and Value/SimpleValue = $codigo  ]/Value
    return element { if( $v/@ColumnRef/string() = "code") then "name" else "label" } { $v/SimpleValue/string() }

  return ( $human, $factory )
};

declare function crd:extraer-nombres($s){
  let $partes := tokenize($s," ")
  let $num := count($partes)
  return switch( $num )
    case 1 return $s
    case 2 return $partes[1]
    case 3 return $partes[1]
    case 4 return $partes[1] || " " || $partes[2]
    default return $partes[1] || " " || $partes[2]
};

declare function crd:primer-nombre($s){
  let $partes := tokenize($s," ")
  let $num := count($partes)
  return switch( $num )
    case 1 return $s
    case 2 return $partes[1]
    case 3 return $partes[1]
    case 4 return $partes[1] 
    default return $partes[1]
};

declare function crd:segundo-nombre($s){
  let $partes := tokenize($s," ")
  let $num := count($partes)
  return switch( $num )
    case 1 return ""
    case 2 return ""
    case 3 return ""
    case 4 return $partes[2] 
    default return $partes[2]
};

declare function crd:primer-apellido($s){
  let $partes := tokenize($s," ")
  let $num := count($partes)
  return switch( $num )
    case 1 return ""
    case 2 return $partes[2] 
    case 3 return $partes[2] 
    case 4 return $partes[2] 
    default return $partes[2]
};


declare function crd:segundo-apellido($s){
  let $partes := tokenize($s," ")
  let $num := count($partes)
  return switch( $num )
    case 1 return ""
    case 2 return ""
    case 3 return $partes[3] 
    case 4 return $partes[4] 
    default return $partes[4] || " " || $partes[5]
};


declare function crd:extraer-apellidos($s){
  let $partes := tokenize($s," ")
  let $num := count($partes)
  return switch( $num )
    case 1 return $s
    case 2 return $partes[2]
    case 3 return $partes[2] || " " || $partes[3]
    case 4 return $partes[3] || " " || $partes[4]
    default return $partes[3] || " " || $partes[4] || " " || $partes[5]
};