var MesitesFE = {

    /* 
    Ejecuta la generación de la factura para una solicitud
    */
    ProcesarSolicitud: async function(idsolicitud, pedido, valor) {
        let answer = window.confirm("¿Está seguro de procesar esta solicitud?");
        if (answer) {
            await Mesites.ProcesarVerifiacion("regla=w-verificar-valores&pedido=" + pedido + "&valor-solicitud=" + valor);
            document.getElementById("spinner_2").classList.add("show");
            await Mesites.Procesar("regla=0-factura-web&id-solicitud=" + idsolicitud, "Resultado proceso de Factura:");

            window.location.reload();
        }
    },

    /*
    Ejecuta la generación de una nota para una factura
    */
    GenerarNotaCredito: function(a, m, numero) {
        let answer = window.confirm("¿Está seguro de realizar esta nota crédito?");
        if (answer) {
            document.getElementById("spinner_2").classList.add("show");
            Mesites.Procesar("regla=nota-credito&a=" + a + "&m=" + m + "&numero=" + numero + ".fe", "Resultado Proceso Nota Credito:");

            window.location.reload();
        }
    },

    /*
    Enviar el correo electronico de una factura
    */
    EnviarCorreo: function(a, m, numero) {
        let answer = window.confirm("¿Está seguro de enviar correo?");
        if (answer) {
            Mesites.Procesar("regla=4-envio-correo&a=" + a + "&m=" + m + "&numero=" + numero + ".fe", " Resultado Proceso envio correo: ");
        }
    },

    /*
    Enviar el correo electronico de una factura preguntando a que direccion
    */
    EnviarCorreoPreg: function(a, m, numero, ext, correo ) {
        let answer = window.prompt("Ingrese la dirección a la que se enviará el correo", correo);
		
		let tipo = ( ext == 'nc' ) ? "notas" : "facturas";
		
        if ( !(answer == null || answer == "") ){
            Mesites.Procesar("regla=4-envio-correo&a=" + a + "&m=" + m + "&numero=" + numero + "." + ext + "&tipodoc=" + tipo + "&destinatario=" + answer, 
				" Resultado Proceso envio correo: ");
        }
    },


    /*
    Rechaza una solicitud
    */
    RechazarSolicitud: async function(idsolicitud, correocliente, pedido) {
        try {
            let answer = window.confirm("¿Está seguro de rechazar esta factura?");
            if (answer) {
                let mensaje = (document.getElementById(`m${idsolicitud}`).value).replace(/%20/g, " ");
                document.getElementById(`md${idsolicitud}`).style.display = 'none';
                await Mesites.Procesar("regla=w-rechazar-solicitud&id-solicitud=" + idsolicitud + "&mail=" + correocliente + "&pedido=" + pedido + "&mensaje=" + mensaje, "Resultado Proceso rechazo solicitud:");
                document.getElementById(`m${idsolicitud}`).value = ""
            }
        } catch (error) {
            console.log(error)
        }
    },

    /*
    Actualiza a la nueva resolucion
    */
    NuevaResolucion: function() {
        let answer = window.confirm("¿Desea acutalizar a la última resolución?");
        if (answer) {
            Mesites.Procesar("regla=x-resoluciones", "Resolución actualizada");
        }
    },

    /*
    Actualiza a la nueva resolucion
    */
    FacturarConsumidor: function( fecha ) {
        let answer = window.confirm("¿Desea generar las facturas de consumidor final para el día " + fecha + "?");
        if (answer) {
            Mesites.Procesar("regla=0-facturas-consumidor&fecha-inicial=" + fecha, "Facturas Consumidor Final");
        }
    },

     ReenviarFirmado: function(a, m, numero, tipo) {
        Mesites.Procesar("regla=x-reenviar&a=" + a + "&m=" + m + "&numero=" + numero + "&tipo=" + tipo, " Resultado Proceso envio DIAN: ");
}    

};